using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXDrvInfo : Form
    {
        private cifXUser cifXUser = new cifXUser();

        public cifXDrvInfo()
        {
            InitializeComponent();
            cifXUser.xDriverGetInformation();
            this.lstList.BeginUpdate();
            this.lstList.Items.Clear();

            this.lstList.Items.Add(new ListViewItem(new string[] { "Driver Version", ByteArrayToString(cifXUser.DriverInformation.abDriverVersion) }));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Board Count", cifXUser.DriverInformation.ulBoardCnt.ToString() }));

            this.lstList.EndUpdate();
            this.lstList.Visible = true;
        }

        private byte[] StringToByteArray(string str)
        {
            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            return enc.GetBytes(str);
        }

        private string ByteArrayToString(byte[] arr)
        {
            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            return enc.GetString(arr);
        }


        private void cifXTest_FormClosed(object sender, FormClosedEventArgs e)
        {
            cifXUser.xDriverClose();
        }

        private void GetGenericInformation()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_INFORMATION);
            this.lstList.Items.Add(new ListViewItem(new string[] { "System Error", string.Format("0x{0:x8}", 
                                                                            cifXUser.SystemChannelInformation.ulSystemError )}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "DPM Total Size", 
                                                                            cifXUser.SystemChannelInformation.ulDpmTotalSize.ToString() }));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Size", 
                                                                            cifXUser.SystemChannelInformation.ulMBXSize.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Device Number", 
                                                                            cifXUser.SystemChannelInformation.ulDeviceNumber.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Serial Number", 
                                                                            cifXUser.SystemChannelInformation.ulSerialNumber.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Open Count", 
                                                                            cifXUser.SystemChannelInformation.ulOpenCnt.ToString()}));
        }

        private void GetInfoBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_INFO_BLOCK);
            this.lstList.Items.Add(new ListViewItem(new string[] { "Cookie", 
                                                                            ByteArrayToString(                                                    
                                                                            cifXUser.SystemchannelSystemInfoBlock.abCookie )
                                                                         }));
            this.lstList.Items.Add(new ListViewItem(new string[] { "DPM Total Size", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulDpmTotalSize.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Device Number", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulDeviceNumber.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Serial Number", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulSerialNumber.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[0]", string.Format("0x{0:x4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[0])}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[1]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[1])}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[2]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[2])}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[3]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[3])}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Manufacturer",      string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usManufacturer)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Production Date",   string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usProductionDate)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "License Flags 1",   string.Format("0x{0:X8}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulLicenseFlags1)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "License Flags 2",   string.Format("0x{0:X8}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulLicenseFlags2)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "netX License ID",   string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usNetxLicenseID)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "netX License Flags",string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usNetxLicenseFlags)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Device Class",      string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usDeviceClass)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Revision", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bHwRevision.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "HW Compatibility", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bHwCompatibility.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Device ID", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bDevIdNumber.ToString()}));
        }

        private void GetChannelBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK);
            
            for (int iChannelDefinition = 0; iChannelDefinition <= cifXUser.CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION - 1; iChannelDefinition++)
            {
                byte[] SizeOfChannel    = new byte[4]{ cifXUser.abInfoBlock[iChannelDefinition, 4],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 5],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 6],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 7]};

                byte[] MailboxOffset    = new byte[2] { cifXUser.abInfoBlock[iChannelDefinition, 10],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 11]};

                byte[] MailboxSize      = new byte[2] { cifXUser.abInfoBlock[iChannelDefinition, 8],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 9]};

                this.lstList.Items.Add(new ListViewItem(new string[] { "Channel " + iChannelDefinition.ToString(),
                                                                       "--------------" }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Type" , GetChannelType(cifXUser.abInfoBlock[iChannelDefinition,0])
                                                                       }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Number of Blocks" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 3].ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Size of Channel" ,
                                                                       BitConverter.ToInt32(SizeOfChannel, 0).ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Start Offset" ,
                                                                       BitConverter.ToInt16(MailboxOffset, 0).ToString() }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Size" ,
                                                                       BitConverter.ToInt16(MailboxSize, 0).ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Handshake Width" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 2].ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Handshake Pos" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 2].ToString() }));
            }
        }

        private string GetChannelType(byte bCHType)
        {
            switch (bCHType)
            {
                case 0x00:
                    return "UNDEFINED";
                case 0x01:
                    return "NOT AVAILABLE";
                case 0x02:
                    return "RESERVED";
                case 0x03:
                    return "SYSTEM";
                case 0x04:
                    return "HANDSHAKE";
                case 0x05:
                    return "COMMUNICATION";
                case 0x06:
                    return "APPLICATION";
            }
            return "RESERVED";
        }

        private void GetControlBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK);
            this.lstList.Items.Add(new ListViewItem(new string[] { "System Command COS", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemControlBlock.ulSystemCommandCOS )}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "Reserved", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemControlBlock.ulReserved )}));
        }

        private void GetStatusBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK);
            this.lstList.Items.Add(new ListViewItem(new string[] { "System COS", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemCOS)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "System Status", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemStatus)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "System Error", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemError)}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "System Start Time [s]", 
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulTimeSinceStart.ToString()}));
            this.lstList.Items.Add(new ListViewItem(new string[] { "System CPU Load [%]", string.Format("{0:2%}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.usCpuLoad)}));
        }
    }
}